<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {
        // Disable foreign key checks temporarily
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('roles')->truncate();
        // Re-enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        DB::table('roles')->insert([ 'id' => 1, 'name' => 'Admin', 'slug' => 'admin', 'access' => '{"faq":{"read":true,"create":true,"delete":true,"update":true},"blog":{"read":true,"create":true,"delete":true,"update":true},"chat":{"read":true,"create":true,"delete":true,"update":true},"smtp":{"read":true,"create":true,"delete":true,"update":true},"type":{"read":true,"create":true,"delete":true,"update":true},"user":{"read":true,"create":true,"delete":true,"update":true},"global":{"read":true,"create":true,"delete":true,"update":true},"pusher":{"read":true,"create":true,"delete":true,"update":true},"status":{"read":true,"create":true,"delete":true,"update":true},"ticket":{"read":true,"create":true,"delete":true,"update":true},"contact":{"read":true,"create":true,"delete":true,"update":true},"category":{"read":true,"create":true,"delete":true,"update":true},"customer":{"read":true,"create":true,"delete":true,"update":true},"language":{"read":true,"create":true,"delete":true,"update":true},"priority":{"read":true,"create":true,"delete":true,"update":true},"department":{"read":true,"create":true,"delete":true,"update":true},"front_page":{"read":true,"create":true,"delete":true,"update":true},"organization":{"read":true,"create":true,"delete":true,"update":true},"email_template":{"read":true,"create":true,"delete":true,"update":true},"knowledge_base":{"read":true,"create":true,"delete":true,"update":true}}']);
        DB::table('roles')->insert([ 'id' => 2,'name' => 'Customer', 'slug' => 'customer', 'access' => '{"faq":{"read":false,"create":false,"delete":false,"update":false},"blog":{"read":false,"create":false,"delete":false,"update":false},"chat":{"read":false,"create":false,"delete":false,"update":false},"smtp":{"read":false,"create":false,"delete":false,"update":false},"type":{"read":false,"create":false,"delete":false,"update":false},"user":{"read":false,"create":false,"delete":false,"update":false},"global":{"read":false,"create":false,"delete":false,"update":false},"pusher":{"read":false,"create":false,"delete":false,"update":false},"status":{"read":false,"create":false,"delete":false,"update":false},"ticket":{"read":true,"create":true,"delete":false,"update":false},"contact":{"read":false,"create":false,"delete":false,"update":false},"category":{"read":false,"create":false,"delete":false,"update":false},"customer":{"read":false,"create":false,"delete":false,"update":false},"language":{"read":false,"create":false,"delete":false,"update":false},"priority":{"read":false,"create":false,"delete":false,"update":false},"department":{"read":false,"create":false,"delete":false,"update":false},"front_page":{"read":false,"create":false,"delete":false,"update":false},"organization":{"read":false,"create":false,"delete":false,"update":false},"email_template":{"read":false,"create":false,"delete":false,"update":false},"knowledge_base":{"read":false,"create":false,"delete":false,"update":false}}']);
        DB::table('roles')->insert([ 'id' => 3,'name' => 'Agency', 'slug' => 'agency', 'access' => '{"faq":{"read":true,"create":true,"delete":true,"update":true},"blog":{"read":true,"create":true,"delete":true,"update":true},"chat":{"read":true,"create":true,"delete":true,"update":true},"smtp":{"read":false,"create":false,"delete":false,"update":false},"type":{"read":false,"create":false,"delete":false,"update":false},"user":{"read":false,"create":false,"delete":false,"update":false},"global":{"read":false,"create":false,"delete":false,"update":false},"pusher":{"read":false,"create":false,"delete":false,"update":false},"status":{"read":false,"create":false,"delete":false,"update":false},"ticket":{"read":true,"create":true,"delete":false,"update":true},"contact":{"read":true,"create":true,"delete":true,"update":true},"category":{"read":false,"create":false,"delete":false,"update":false},"customer":{"read":true,"create":true,"delete":false,"update":true},"language":{"read":false,"create":false,"delete":false,"update":false},"priority":{"read":false,"create":false,"delete":false,"update":false},"department":{"read":false,"create":false,"delete":false,"update":false},"front_page":{"read":false,"create":false,"delete":false,"update":false},"organization":{"read":true,"create":true,"delete":true,"update":true},"email_template":{"read":false,"create":false,"delete":false,"update":false},"knowledge_base":{"read":false,"create":false,"delete":false,"update":false}}']);
        DB::table('roles')->insert([ 'id' => 4,'name' => 'Manager', 'slug' => 'manager', 'access' => '{"faq":{"read":true,"create":true,"delete":true,"update":true},"blog":{"read":true,"create":true,"delete":true,"update":true},"chat":{"read":true,"create":true,"delete":true,"update":true},"smtp":{"read":false,"create":false,"delete":false,"update":false},"type":{"read":false,"create":false,"delete":false,"update":false},"user":{"read":false,"create":false,"delete":false,"update":false},"global":{"read":false,"create":false,"delete":false,"update":false},"pusher":{"read":false,"create":false,"delete":false,"update":false},"status":{"read":false,"create":false,"delete":false,"update":false},"ticket":{"read":true,"create":true,"delete":false,"update":true},"contact":{"read":true,"create":true,"delete":true,"update":true},"category":{"read":false,"create":false,"delete":false,"update":false},"customer":{"read":true,"create":true,"delete":false,"update":true},"language":{"read":false,"create":false,"delete":false,"update":false},"priority":{"read":false,"create":false,"delete":false,"update":false},"department":{"read":false,"create":false,"delete":false,"update":false},"front_page":{"read":false,"create":false,"delete":false,"update":false},"organization":{"read":true,"create":true,"delete":true,"update":true},"email_template":{"read":false,"create":false,"delete":false,"update":false},"knowledge_base":{"read":false,"create":false,"delete":false,"update":false}}']);
        DB::table('roles')->insert([ 'id' => 5,'name' => 'General', 'slug' => 'general', 'access' => '{"faq":{"read":false,"create":false,"delete":false,"update":false},"blog":{"read":false,"create":false,"delete":false,"update":false},"chat":{"read":false,"create":false,"delete":false,"update":false},"smtp":{"read":false,"create":false,"delete":false,"update":false},"type":{"read":false,"create":false,"delete":false,"update":false},"user":{"read":false,"create":false,"delete":false,"update":false},"global":{"read":false,"create":false,"delete":false,"update":false},"pusher":{"read":false,"create":false,"delete":false,"update":false},"status":{"read":false,"create":false,"delete":false,"update":false},"ticket":{"read":true,"create":true,"delete":true,"update":true},"contact":{"read":false,"create":false,"delete":false,"update":false},"category":{"read":false,"create":false,"delete":false,"update":false},"customer":{"read":false,"create":false,"delete":false,"update":false},"language":{"read":false,"create":false,"delete":false,"update":false},"priority":{"read":false,"create":false,"delete":false,"update":false},"department":{"read":false,"create":false,"delete":false,"update":false},"front_page":{"read":false,"create":false,"delete":false,"update":false},"organization":{"read":false,"create":false,"delete":false,"update":false},"email_template":{"read":false,"create":false,"delete":false,"update":false},"knowledge_base":{"read":false,"create":false,"delete":false,"update":false}}']);
        DB::table('roles')->insert([ 'id' => 6,'name' => 'Agent', 'slug' => 'agent', 'access' => '{"faq":{"read":false,"create":false,"delete":false,"update":false},"blog":{"read":false,"create":false,"delete":false,"update":false},"chat":{"read":true,"create":true,"delete":true,"update":true},"smtp":{"read":false,"create":false,"delete":false,"update":false},"type":{"read":false,"create":false,"delete":false,"update":false},"user":{"read":false,"create":false,"delete":false,"update":false},"global":{"read":false,"create":false,"delete":false,"update":false},"pusher":{"read":false,"create":false,"delete":false,"update":false},"status":{"read":false,"create":false,"delete":false,"update":false},"ticket":{"read":true,"create":true,"delete":true,"update":true},"contact":{"read":false,"create":false,"delete":false,"update":false},"category":{"read":false,"create":false,"delete":false,"update":false},"customer":{"read":false,"create":false,"delete":false,"update":false},"language":{"read":false,"create":false,"delete":false,"update":false},"priority":{"read":false,"create":false,"delete":false,"update":false},"department":{"read":false,"create":false,"delete":false,"update":false},"front_page":{"read":false,"create":false,"delete":false,"update":false},"organization":{"read":false,"create":false,"delete":false,"update":false},"email_template":{"read":false,"create":false,"delete":false,"update":false},"knowledge_base":{"read":false,"create":false,"delete":false,"update":false}}']);

    }
}
