<?php

namespace App\Providers;

use App\Events\AssignedUser;
use App\Events\CommentAdded;
use App\Events\ConversationCreated;
use App\Events\ForgotPassword;
use App\Events\SendMail;
use App\Events\TicketAdded;
use App\Events\TicketCreated;
use App\Events\TicketNewComment;
use App\Events\TicketUpdated;
use App\Events\UserCreated;
use App\Listeners\CommentAddedNotification;
use App\Listeners\SendAssignedUserNotification;
use App\Listeners\SendForgotPasswordNotification;
use App\Listeners\SendMailNotification;
use App\Listeners\SendTicketNewCommentNotification;
use App\Listeners\SendTicketUpdatedNotification;
use App\Listeners\TicketAddingOption;
use App\Listeners\TicketCreatedNotification;
use App\Listeners\UserCreatedNotification;
// New centralized notification listeners
use App\Listeners\NewTicketCreatedListener;
use App\Listeners\NewTicketUpdatedListener;
use App\Listeners\NewTicketAssignedListener;
use App\Listeners\NewTicketCommentListener;
use App\Listeners\NewUserCreatedListener;
use App\Listeners\ConversationCreatedNotification;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        'App\Events\NewChatMessage' => [
            'App\Listeners\SendChatMessageNotification'
        ],
        ConversationCreated::class => [
            ConversationCreatedNotification::class,
        ],
        TicketAdded::class => [
            TicketAddingOption::class
        ],
        TicketCreated::class => [
            TicketCreatedNotification::class, // Keep old listener for backward compatibility
            NewTicketCreatedListener::class,  // New centralized listener
        ],
        AssignedUser::class => [
            SendAssignedUserNotification::class, // Keep old listener for backward compatibility
            NewTicketAssignedListener::class,    // New centralized listener
        ],
        TicketUpdated::class => [
            SendTicketUpdatedNotification::class, // Keep old listener for backward compatibility
            NewTicketUpdatedListener::class,      // New centralized listener
        ],
        TicketNewComment::class => [
            SendTicketNewCommentNotification::class, // Keep old listener for backward compatibility
            NewTicketCommentListener::class,         // New centralized listener
        ],
        UserCreated::class => [
            UserCreatedNotification::class, // Keep old listener for backward compatibility
            NewUserCreatedListener::class,  // New centralized listener
        ],
        ForgotPassword::class => [
            SendForgotPasswordNotification::class
        ],
        SendMail::class => [
            SendMailNotification::class
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
